<?php

namespace App\Http\Resources\API;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class BookAppointmentsResource extends JsonResource
{
    public static $wrap = null;
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $customer = $this->relationLoaded('customer') ? $this->whenLoaded('customer') : null;
        $therapist = $this->relationLoaded('therapist') ? $this->whenLoaded('therapist') : null;
        $therapist_community = $this->relationLoaded('therapist_community') ? $this->whenLoaded('therapist_community') : null;
        $appointment_status = $this->relationLoaded('appointment_status') ? $this->whenLoaded('appointment_status') : null;
        $appointment_type = $this->relationLoaded('appointment_type') ? $this->whenLoaded('appointment_type') : null;
        $messages = $this->relationLoaded('messages') ? $this->whenLoaded('messages') : null;
        return [
            "id" =>  $this->id,
            "customer_id" =>  $this->customer_id,
            "customer_name" => $customer ? $customer->name : null,
            "customer_image" => $customer ? $customer->image : null,
            "appointment_status_name" => $appointment_status ? $appointment_status->display_name : null,
            "appointment_type_name" => !empty($appointment_type) ? $appointment_type->display_name : null,
            "is_schedule_required" => !empty($appointment_type) && $appointment_type->is_schedule_required ? 1 : 0,
            "therapist_id" =>  $this->therapist_id,
            "therapist_name" => $therapist ? $therapist->name : null,
            "therapist_image" => $therapist ? $therapist->image : null,
            "therapist_community_id" =>  $this->therapist_community_id,
            "therapist_community_name" => $therapist_community->name ?? null,
            "therapist_community_image" => $therapist_community->image ?? null,
            "date" => Carbon::parse($this->date)->format('d/m/Y'),
            "start_time" =>  $this->start_time,
            "end_time" =>  $this->end_time,
            "fee" =>  $this->fee,
            "is_paid" =>  $this->is_paid,
            "appointment_type_id" =>  $this->appointment_type_id,
            "appointment_type" =>  $this->appointment_type->type,
            "question" =>  $this->question,
            "attachment_url" =>  $this->attachment_url,
            "appointment_status_code" =>  $this->appointment_status_code,
            "messages" => $messages ? MessagesResource::collection($messages):[],
            "is_started" => $this->is_started,
            "is_ended" => $this->is_ended,
            "started_at" => $this->started_at,
            "ended_at" => $this->ended_at,
            "created_at" =>  $this->created_at,
            "updated_at" =>  $this->updated_at,
        ];
    }
}
